
// DNN ver. 0.01 (18/11/2015)
// Copyright (C) Gianluca Pollastri 2015


#include "DNN.h"





void
DNN::alloc() {
int t;

Hcache = new double**[NLayers+1];
Hcachebp = new double**[NLayers+1];
for (int l=0;l<=NLayers;l++) {
	Hcache[l] = new double*[MAX];
	Hcachebp[l] = new double*[MAX];
	for (int t=0;t<MAX;t++) {
		Hcache[l][t] = new double[Ht[l]];
		Hcachebp[l][t] = new double[Ht[l]];
		memset(Hcache[l][t],0,Ht[l]*sizeof(double));
		memset(Hcachebp[l][t],0,Ht[l]*sizeof(double));
	}
}

/*
// Top cache double the size to (redundantly) accommodate the global pooling input
	Hcache[NLayers] = new double*[MAX];
	Hcachebp[NLayers] = new double*[MAX];
	for (int t=0;t<MAX;t++) {
		Hcache[NLayers][t] = new double[2*Ht[NLayers]];
		Hcachebp[NLayers][t] = new double[2*Ht[NLayers]];
		memset(Hcache[NLayers][t],0,2*Ht[NLayers]*sizeof(double));
		memset(Hcachebp[NLayers][t],0,2*Ht[NLayers]*sizeof(double));
	}
*/


HcacheGlobal = new double[Ht[NLayers]];
HcacheGlobalbp = new double[Ht[NLayers]];
memset(HcacheGlobal,0,Ht[NLayers]*sizeof(double));
memset(HcacheGlobalbp,0,Ht[NLayers]*sizeof(double));

Y=new double[NY];
BP=new double[MAX*NU];
}


DNN::DNN(int the_NU, int the_NY, int the_NLayers, int the_NHo, int* the_NHt, int* the_Ht, int the_NHi, int the_Hi, int the_gamma, int the_context, int the_doubleo) :
NU(the_NU), NY(the_NY), NLayers(the_NLayers), NHo(the_NHo), NHi(the_NHi), Hi(the_Hi), gamma(the_gamma), context(the_context), doubleo(the_doubleo)
{

int NK[8196];
int NKgamma[8196];


for (int c=0;c<2*context+1;c++) {
	NK[c]=NU;
}
for (int c=0;c<8196;c++) {
	NKgamma[c]=1;
}

NHt = new int[NLayers];
Ht = new int[NLayers+1];
Ht[0] = Hi;
for (int c=0;c<NLayers;c++) {
	NHt[c] = the_NHt[c];
	Ht[c+1] = the_Ht[c];
}

NetO = new NN(0, Ht[NLayers], NHo, NY, NK);
NetO->set_input(2);
NetO->set_output(1);


NetT = new NNt*[NLayers];

for (int l=0;l<NLayers;l++) {
	NetT[l] = new NNt(0,(2*gamma+1)*Ht[l],NHt[l],Ht[l+1],NKgamma,0);
	NetT[l] ->set_input(2);
	NetT[l] ->set_output(0);
}

NetI = new NNt((2*context+1),0,NHi,Hi,NK,0);
NetI->set_input(0);
NetI->set_output(0);

alloc();
resetGradient();
}




DNN::DNN(istream& is, int the_NU, int the_NY, int the_NLayers, int the_NHo, int* the_NHt, int* the_Ht, int the_NHi, int the_Hi, int the_gamma, int the_context, int the_doubleo) :
NU(the_NU), NY(the_NY), NLayers(the_NLayers), NHo(the_NHo), NHi(the_NHi), Hi(the_Hi), gamma(the_gamma), context(the_context), doubleo(the_doubleo)
{

int NK[8196];
int NKgamma[8196];


for (int c=0;c<2*context+1;c++) {
	NK[c]=NU;
}
for (int c=0;c<8196;c++) {
	NKgamma[c]=1;
}

NHt = new int[NLayers];
Ht = new int[NLayers+1];
Ht[0] = Hi;
for (int c=0;c<NLayers;c++) {
	NHt[c] = the_NHt[c];
	Ht[c+1] = the_Ht[c];
}
NetT = new NNt*[NLayers];



int dummy;
double fdummy; 

is >> dummy >> dummy >> dummy;
is >> dummy >> dummy >> dummy;
for (int c=0;c<NLayers-1;c++) {
	is >> dummy;
	is >> dummy;
}
is >> dummy >> dummy >> fdummy;

NN* dummynet = new NN(is);

cout << dummynet->get_NI() << " " << dummynet->get_NIr() << " " << dummynet->get_NH() << " " << dummynet->get_NO() << "\n" << flush;

delete dummynet;

for (int l=0;l<NLayers-1;l++) {
	NetT[l] = new NNt(is);
	NetT[l] ->set_input(2);
	NetT[l] ->set_output(0);
}
//NNt* dummynet2 = new NNt(is);
//delete dummynet2;

NetI = new NNt(is);
NetI->set_input(0);
NetI->set_output(0);

NetO = new NN(0, Ht[NLayers], NHo, NY, NK);
NetO->set_input(2);
NetO->set_output(1);

NetT[NLayers-1] = new NNt(0,(2*gamma+1)*Ht[NLayers-1],NHt[NLayers-1],Ht[NLayers],NKgamma,0);
NetT[NLayers-1] ->set_input(2);
NetT[NLayers-1] ->set_output(0);

alloc();
resetGradient();
}









DNN::DNN(istream& is) {
is >> NU >> NY >> NLayers;

NetT = new NNt*[NLayers];
NHt = new int[NLayers];
Ht = new int[NLayers+1];

is >> NHo >> NHi >> Hi;
Ht[0] = Hi;

for (int c=0;c<NLayers;c++) {
	is >> NHt[c];
	is >> Ht[c+1];
}
is >> gamma >> context >> doubleo;

NetO = new NN(is);
NetO->set_input(2);
NetO->set_output(1);



for (int l=0;l<NLayers;l++) {
	NetT[l] = new NNt(is);
	NetT[l] ->set_input(2);
	NetT[l] ->set_output(0);
}
NetI = new NNt(is);
NetI->set_input(0);
NetI->set_output(0);

alloc();
resetGradient();
}





void
DNN::read(istream& is) {
is >> NU >> NY >> NLayers;
is >> NHo >> NHi >> Hi;
Ht[0] = Hi;
for (int c=0;c<NLayers;c++) {
	is >> NHt[c];
	is >> Ht[c+1];
}
is >> gamma >> context >> doubleo;



NetO->read(is);
NetO->set_input(2);
NetO->set_output(1);

for (int l=0;l<NLayers;l++) {
	NetT[l]->read(is);
	NetT[l] ->set_input(2);
	NetT[l] ->set_output(0);
}

NetI->read(is);
NetI->set_input(0);
NetI->set_output(0);
memset(HcacheGlobal,0,Ht[NLayers]*sizeof(double));
}



void
DNN::write(ostream& os) {
os << NU << " " << NY << " " << NLayers << "\n";
os << NHo << " " << NHi << " " << Hi << "\n";

for (int c=0;c<NLayers;c++) {
	os << NHt[c] << " ";
	os << Ht[c+1] << " ";
}
os << "\n";
os << gamma << " " << context << " " << doubleo << "\n";


NetO->write(os);
for (int l=0;l<NLayers;l++) {
	NetT[l]->write(os);
}
NetI->write(os);
}


void
DNN::resetGradient() {
NetO->resetGradient();
for (int l=0;l<NLayers;l++) {
	NetT[l]->resetGradient();
}
NetI->resetGradient();
}

void
DNN::initWeights(int seed) {
NetO->initWeights(seed++);
for (int l=0;l<NLayers;l++) {
	NetT[l]->initWeights(seed++);
}
NetI->initWeights(seed++);
}





void
DNN::initWeights_top(int seed) {
NetO->initWeights(seed++);
NetT[NLayers-1]->initWeights(seed++);
}





void 
DNN::I_T(double* seq, int t, int length){
double I[8196];
int c,h;

  for (c=-context; c<=context; c++) {
    if (t+c <= 0 || t+c > length) {
	for (int i=0;i<NU;i++)
		I[NU*(context+c)+i] = 0.0;
    } else {
	for (int i=0;i<NU;i++)
		I[NU*(context+c)+i] = seq[NU*(t+c)+i];
      }
    }
double*X;
NNt* tempo = new NNt(NetI);
tempo->forward(I,X);

  for (h=0;h<Hi;h++) {
	Hcache[0][t][h] = tempo->out()[h];
  }
delete tempo;
}



void 
DNN::I_T(double* seq, int t1, int t2, int length){
double I[8196];
int c,h;
double*X;
NNt* tempo = new NNt(NetI);

for (int t=t1; t<t2; t++) {
  for (c=-context; c<=context; c++) {
    if (t+c <= 0 || t+c > length) {
	for (int i=0;i<NU;i++)
		I[NU*(context+c)+i] = 0.0;
    } else {
	for (int i=0;i<NU;i++)
		I[NU*(context+c)+i] = seq[NU*(t+c)+i];
      }
    }
  tempo->forward(I,X);

  for (h=0;h<Hi;h++) {
	Hcache[0][t][h] = tempo->out()[h];
  }
}
delete tempo;
}



void 
DNN::I_T(int* seq, int t, int length){
int I[8196];
int c,h;

  for (c=-context; c<=context; c++) {
    if (t+c <= 0 || t+c > length) {
		I[context+c] = -1;
    } else {
		I[context+c] = seq[t+c];
    }
  }
double*X;
NNt* tempo = new NNt(NetI);
tempo->forward(I,X);

  for (h=0;h<Hi;h++) {
	Hcache[0][t][h] = tempo->out()[h];
  }
delete tempo;
}



void 
DNN::I_T(int* seq, int t1, int t2, int length){
int I[8196];
int c,h;
double*X;
NNt* tempo = new NNt(NetI);


for (int t=t1; t<t2; t++) {
  for (c=-context; c<=context; c++) {
    if (t+c <= 0 || t+c > length) {
		I[context+c] = -1;
    } else {
		I[context+c] = seq[t+c];
    }
  }
  tempo->forward(I,X);

  for (h=0;h<Hi;h++) {
	Hcache[0][t][h] = tempo->out()[h];
  }
}

delete tempo;
}



void 
DNN::T_T(int Lay, int t, int length){
double I[8196];
int c,h;

  for (c=-gamma; c<=gamma; c++) {
    if (t+c <= 0 || t+c > length) {
	for (h=0;h<Ht[Lay];h++)
		I[Ht[Lay]*(gamma+c)+h] = 0.0;
    } else {
	for (h=0;h<Ht[Lay];h++)
		I[Ht[Lay]*(gamma+c)+h] = Hcache[Lay][t+c][h];
    }
  }
double*X;
NNt* tempo = new NNt(NetT[Lay]);
tempo->forward(X,I);

  for (h=0;h<Ht[Lay+1];h++) {
	Hcache[Lay+1][t][h] = tempo->out()[h];
  }
delete tempo;
}



void 
DNN::T_T(int Lay, int t1, int t2, int length){
double I[8196];
int c,h;
double*X;
NNt* tempo = new NNt(NetT[Lay]);

for (int t=t1; t<t2; t++) {
  for (c=-gamma; c<=gamma; c++) {
    if (t+c <= 0 || t+c > length) {
	for (h=0;h<Ht[Lay];h++)
		I[Ht[Lay]*(gamma+c)+h] = 0.0;
    } else {
	for (h=0;h<Ht[Lay];h++)
		I[Ht[Lay]*(gamma+c)+h] = Hcache[Lay][t+c][h];
    }
  }
  tempo->forward(X,I);

  for (h=0;h<Ht[Lay+1];h++) {
	Hcache[Lay+1][t][h] = tempo->out()[h];
  }
}
delete tempo;
}



void 
DNN::T_O(){
double*X;
NetO->forward(X,HcacheGlobal);
for (int y=0;y<NY;y++) {
	Y[y] = NetO->out()[y];
}
}


int min(int a, int b) {
	if (a<b) return a;
	return b;
}


void
DNN::make_global_input(int length) {
int t;

memset(HcacheGlobal,0,Ht[NLayers]*sizeof(double));
for (t=1;t<=length;t++) {
	for (int h=0;h<Ht[NLayers];h++) {
		HcacheGlobal[h] += Hcache[NLayers][t][h];
	}
}

for (int h=0;h<Ht[NLayers];h++) {
	if (avgpool) {
		HcacheGlobal[h] *= 5.0/length;
	} else {
		HcacheGlobal[h] *= 0.01;
	}
}
}


void 
DNN::propagate(double* seq, int length) {
int t,l;
int chunk = length/NTH;

#pragma omp parallel num_threads(NTH)
{
#pragma omp for
for (t=1;t<=length;t+=chunk) {
	I_T(seq,t,min(t+chunk, length+1),length);
}
}

for (l=0;l<NLayers;l++) {
	#pragma omp parallel num_threads(NTH)
	{
	#pragma omp for
	for (t=1;t<=length;t+=chunk) {
		T_T(l,t,min(t+chunk, length+1),length);
	}
	}
}

make_global_input(length);

T_O();

}



void 
DNN::propagate(int* seq, int length) {
int t,l;
int chunk = length/NTH;

#pragma omp parallel num_threads(NTH)
{
#pragma omp for
for (t=1;t<=length;t+=chunk) {
	I_T(seq,t,min(t+chunk, length+1),length);
}
}

for (l=0;l<NLayers;l++) {
	#pragma omp parallel num_threads(NTH)
	{
	#pragma omp for
	for (t=1;t<=length;t+=chunk) {
		T_T(l,t,min(t+chunk, length+1),length);
	}
	}
}

make_global_input(length);

T_O();

}

























void 
DNN::clear_cache() {
for (int l=0;l<=NLayers;l++) {
	for (int t=0;t<MAX;t++) {
		memset(Hcachebp[l][t],0,Ht[l]*sizeof(double));
	}
}
}



































void
DNN::Feed(double* seq, int length) {
int t;

propagate(seq,length);
}

void
DNN::Feed(int* seq, int length) {
int t;

propagate(seq,length);
}





void
DNN::predict(double* seq, int length) {

Feed(seq,length);
}

void
DNN::predict(int* seq, int length) {

Feed(seq,length);
}

