



#include "MModel.h"




void
MModel::alloc() {

	counted = new int[NY];
	nerrors_ = new int[NY];

	Conf=new int*[NY];
	for (int y=0;y<NY;y++)
		Conf[y]=new int[NY];
}





MModel::MModel(istream& is, int ny) {

NY = ny;

char fname[256];
filebuf inbuf;

is >> nModels;
M=new Model*[nModels];

for (int n=0;n<nModels; n++) {
  is>>fname;
  inbuf.open(fname, ios::in);
  istream is2(&inbuf);

  M[n] = new Model(is2);
  M[n]->resetNErrors();

  inbuf.close();
}

alloc();

}







void
MModel::predict(Sequence* seq) {

int c;


	for (c=0; c<NY; c++) {
		seq->y_pred_probs[c] = 0;
	}

	for (int n=0;n<nModels; n++) {
		M[n]->predictN(seq,nModels);
	}

	  double pred=0.0;
	  int argp=-1;

	  for (int c=0; c<NY; c++) {
		  if (seq->y_pred_probs[c]>pred) {
			  pred = seq->y_pred_probs[c];
			  argp = c;
		  }
	  }
	  seq->y_pred = argp;

	  if (seq->y_pred != seq->yc) {
		    nerrors++;
		    nerrors_[seq->yc]++;
	  }
	
	if (seq->yc != -1 && seq->y_pred != -1) {
	  Conf[seq->y_pred][seq->yc]++;
	  counted[seq->yc]++;
	}

}












