
#ifndef MModel_h
#define MModel_h 1

#include <stdlib.h>
#include <math.h>
#include "Sequence.h"
#include "Model.h"


class MModel {
 private:
  int nModels;

  int NY;

  Model** M;

  int** Conf;

  int temp_aas;
  
  int* counted;
  double squared_error;
  double error;
  int nerrors;
  int* nerrors_;

  double epsilon;

  void alloc();


 public:

  MModel(istream& is, int ny);

  void predict(Sequence* seq);


  int** getConf() {return Conf;}
  int getNErrors() { return nerrors;};
  int getNErrors_(int i) { return nerrors_[i];};
  int getClasses() { return NY;};

  int* getCounted() {return counted;}

   void resetNErrors() { 
	error=0;
	nerrors=0;
	memset(nerrors_,0,NY*sizeof(int));
	memset(counted,0,NY*sizeof(int));
	for (int p=0;p<NY;p++)
	  for (int y=0;y<NY;y++)
		Conf[p][y]=0;
	};

  double get_error() { 
	return error;
	};

  void reset_squared_error() { 
	error = 0;
	};


};


#endif // MModel_h
