



#include "Model.h"




void
Model::alloc() {

	counted = new int[NY];
	nerrors_ = new int[NY];
	pred_y = new int[NY];//CM Tuesday 14 August 2018 

	Conf=new int*[NY];
	for (int y=0;y<NY;y++)
		Conf[y]=new int[NY];


}



Model::Model(int the_NU, int the_NY, int the_NLayers, int the_NHo, int* the_NHt, int* the_Ht, int the_NHi, int the_Hi, 
		  int the_gamma, int the_context, double* the_Thresholds) :
NU(the_NU), NY(the_NY), NLayers(the_NLayers), NHo(the_NHo), NHi(the_NHi), Hi(the_Hi), gamma(the_gamma), context(the_context)
{

Thresholds = new double[NY];
for (int y=0;y<NY-1;y++) 
	Thresholds[y] = the_Thresholds[y];

NHt = new int[NLayers];
Ht = new int[NLayers];

for (int c=0;c<NLayers;c++) {
	NHt[c] = the_NHt[c];
	Ht[c] = the_Ht[c];
}

Net = new DNN(NU,NY,NLayers,NHo,NHt,Ht,NHi,Hi,gamma,context);
Net->resetGradient();

alloc();
}





Model::Model(istream& is, int the_NU, int the_NY, int the_NLayers, int the_NHo, int* the_NHt, int* the_Ht, int the_NHi, int the_Hi, 
		  int the_gamma, int the_context, double* the_Thresholds) :
NU(the_NU), NY(the_NY), NLayers(the_NLayers), NHo(the_NHo), NHi(the_NHi), Hi(the_Hi), gamma(the_gamma), context(the_context)
{

Thresholds = new double[NY];
for (int y=0;y<NY-1;y++) 
	Thresholds[y] = the_Thresholds[y];

NHt = new int[NLayers];
Ht = new int[NLayers];

for (int c=0;c<NLayers;c++) {
	NHt[c] = the_NHt[c];
	Ht[c] = the_Ht[c];
}

int dummy;
double fdummy;
is >> dummy >> dummy >> dummy;
is >> dummy >> dummy >> dummy;
for (int c =0;c<NLayers-1;c++) {
	is >> dummy;
	is >> dummy;
}
is >> dummy >> dummy;

for (int y=0;y<NY-1;y++) 
	is >> fdummy;

Net = new DNN(is, NU,NY,NLayers,NHo,NHt,Ht,NHi,Hi,gamma,context);
Net->resetGradient();

alloc();
}





Model::Model(istream& is) {
is >> NU >> NY >> NLayers;
is >> NHo >> NHi >> Hi;
NHt = new int[NLayers];
Ht = new int[NLayers];
for (int c =0;c<NLayers;c++) {
	is >> NHt[c];
	is >> Ht[c];
}
is >> gamma >> context;

Thresholds = new double[NY];
for (int y=0;y<NY-1;y++) 
	is >> Thresholds[y];

Net = new DNN(is);
Net->resetGradient();

alloc();
}





void
Model::read(istream& is) {
is >> NU >> NY >> NLayers;
is >> NHo >> NHi >> Hi;
for (int c =0;c<NLayers;c++) {
	is >> NHt[c];
	is >> Ht[c];
}
is >> gamma >> context;
for (int y=0;y<NY-1;y++) 
	is >> Thresholds[y];

Net->read(is);
Net->resetGradient();
}




void
Model::write(ostream& os) {
os << NU << " " << NY << " " << NLayers << "\n";
os << NHo << " " << NHi << " " << Hi << "\n";
for (int c =0;c<NLayers;c++) {
	os << NHt[c] << " ";
	os << Ht[c] << " ";
}
os << "\n";
os << gamma << " " << context << "\n";

for (int y=0;y<NY-1;y++) 
	os << Thresholds[y] << " ";
os << "\n";

Net->write(os);
}



void
Model::randomize(int seed) {
Net->initWeights(seed);
}



void
Model::randomize_top(int seed) {
Net->initWeights_top(seed);
}






void
Model::predict(Sequence* seq) {


int t,y;

int a,c;//,m,maxm;
double sum=0;

double* app=new double[NY];


	sum=0;

	int O;

		int close = 0;
		for (y=0;y<NY-1;y++) {
			if (seq->y>Thresholds[y]) {
				close =y+1;
			}
		}
		O = close;
		seq->yc = close;

	Net->predict(seq->u,seq->length);
		for (c=0; c<NY; c++) {
			app[c]=Net->out()[c];
			seq->y_pred_probs[c] = Net->out()[c];
		}


	  double pred=0.0;
	  int argp=-1;
	  for (int c=0; c<NY; c++) {
		  if (app[c]>pred) {
			  pred = app[c];
			  argp = c;
		  }
	  }
	  seq->y_pred = argp;



	  if (seq->y_pred!=seq->yc) {
		    nerrors++;
		    nerrors_[seq->yc]++;
	  }
	
	if (seq->yc != -1 && seq->y_pred != -1) {
	  Conf[seq->y_pred][seq->yc]++;
	  counted[seq->yc]++;
          pred_y[seq->yc]++;//CM Tuesday 14 August 2018 
	}


delete[] app;
}








//CM Wednesday 29 August 2018 
void
Model::predictN(Sequence* seq, int nModels) {

int c;

	Net->predict(seq->u,seq->length);
		for (c=0; c<NY; c++) {
			seq->y_pred_probs[c] += Net->out()[c] / nModels;
		}
}




