
#include <math.h>
#include <iostream>
#include <fstream>
#include <string.h>
#include <stdlib.h>

#include "MModel.h"
#include "Sequence.h"

using namespace std;





void
evaluate(MModel* M, DataSet& D, char* which)
{
	int y;

  cout << "\n counting_" << which << "_errors" << flush;
  M->resetNErrors();
  int p;
  for (p=0; p<D.length; p++) {
    M->predict(D.seq[p]);
    if (p%200==0) cout << "." << flush;
  }

double a[128];
double all=0;

for (y=0;y<M->getClasses();y++) {
	a[y]=M->getCounted()[y];
	all += M->getCounted()[y];
}

  cout << "\n\n" << which << "_NErrors= " << M->getNErrors() << "/" << all;
  cout << " " << (double)M->getNErrors()/(double)(all)*100.0;

for (y=0;y<M->getClasses();y++) {
  cout << "\nClass" << y << "= " << M->getNErrors_(y) << "/" << a[y];
  cout << "\t" << (double)M->getNErrors_(y)/(double)a[y]*100.0;
}

  cout<<"\n\n";


cout << "Confusion matrix:\n";
for (y=0;y<M->getClasses();y++) {
	for (int yy=0;yy<M->getClasses();yy++) {
		cout << M->getConf()[y][yy] << "\t";
	}
	cout << "\n";
}


	//CM Wednesday 29 August 2018 Add MCC
	float TP = M->getConf()[0][0];
	float TN = M->getConf()[1][1];
	float FP = M->getConf()[0][1];
	float FN = M->getConf()[1][0];

	//cout<<"TP " << TP <<" FP " << FP <<" TN " << TN <<" FN " << FN <<   "\n";
	//float Spec 	= 100 * (TP/(TP + FP));//precision/specificity TN/TN+FP
	//float Sen 	= 100 * (TP/(TP + FN));//sensitivity/recall/TPR
	//float FPR 	= 100 * (FP/(FP + TN));//false positive rate
	float MCC 	= (TP * TN - FP * FN)/sqrt((TP + FP)*(TP + FN)*(TN + FP)*(TN + FN));

	//cout<<"Spec " << Spec << "\t";
	//cout<<"Sen " << Sen << "\t";
	//cout<<"FPR " << FPR << "\t";
//	cout<<"\n\nMCC " << MCC << "\n";


}





int
main(int argc, char** argv)
{
  if (argc<3) {
    cerr << "Usage: " << argv[0] << " model dataset\n";
    exit(1);
  }

	char prot[256];//CM Wednesday 29 August 2018 
    strcpy(prot,argv[2]);
	strcat(prot,".predictions");

  cout << "Reading dataset\n"<<flush;
  ifstream dstream(argv[2]);
  DataSet D(dstream);
  int ny = D.classes;

  MModel* M;
  ifstream mstream(argv[1]);
  M = new MModel(mstream,ny);

  evaluate(M, D, "train");
  //D.write_probs("predictions");
  D.write_probs(prot);//CM Wednesday 29 August 2018 

  return 0;
}


